/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.completable;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Completable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableCache
extends Completable
implements CompletableObserver {
    static final InnerCompletableCache[] EMPTY = new InnerCompletableCache[0];
    static final InnerCompletableCache[] TERMINATED = new InnerCompletableCache[0];
    final CompletableSource source;
    final AtomicReference<InnerCompletableCache[]> observers;
    final AtomicBoolean once;
    Throwable error;

    public CompletableCache(CompletableSource source) {
        this.source = source;
        this.observers = new AtomicReference<InnerCompletableCache[]>(EMPTY);
        this.once = new AtomicBoolean();
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        InnerCompletableCache inner = new InnerCompletableCache(observer);
        observer.onSubscribe(inner);
        if (this.add(inner)) {
            if (inner.isDisposed()) {
                this.remove(inner);
            }
            if (this.once.compareAndSet(false, true)) {
                this.source.subscribe(this);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                observer.onError(ex);
            } else {
                observer.onComplete();
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        for (InnerCompletableCache inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.get()) continue;
            inner.downstream.onError(e);
        }
    }

    @Override
    public void onComplete() {
        for (InnerCompletableCache inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.get()) continue;
            inner.downstream.onComplete();
        }
    }

    boolean add(InnerCompletableCache inner) {
        InnerCompletableCache[] b;
        InnerCompletableCache[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new InnerCompletableCache[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(InnerCompletableCache inner) {
        InnerCompletableCache[] b;
        InnerCompletableCache[] a;
        do {
            int n;
            if ((n = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new InnerCompletableCache[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    final class InnerCompletableCache
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 8943152917179642732L;
        final CompletableObserver downstream;

        InnerCompletableCache(CompletableObserver downstream) {
            this.downstream = downstream;
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                CompletableCache.this.remove(this);
            }
        }
    }
}

